﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.Links;
using VIMT.VIAEMRService.Messages;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class CreateResponseStep : FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            GetConsultsforPatientMapper mapper = new GetConsultsforPatientMapper();
            
            if (!string.IsNullOrEmpty(state.ConsultsFakeResponseType))
            {
                state.GetConsultsResponse = new GetConsultsForPatientResponse
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO VISTA*****",
                    ExceptionOccured = false,
                    ProGetConsultsForPatientRespTaggedConsultArraysInfo = mapper.MapEcToLob(state.ProEcResponse),
                    PatGetConsultsForPatientRespTaggedConsultArraysInfo = mapper.MapEcToLob(state.PatEcResponse),
                    ProUserDuz = state.ProUserDuz,
                    PatUserDuz = state.PatUserDuz
                };
            }
            else
            {
                state.GetConsultsResponse = state.ExceptionOccured
                    ? new GetConsultsForPatientResponse
                    {
                        ExceptionOccured = true,
                        ExceptionMessage = state.ExceptionMessage,
                        EcProcessingMs = state.EcProcessingTimeMs
                    }
                    : new GetConsultsForPatientResponse
                    {
                        ExceptionMessage = string.Empty,
                        ExceptionOccured = false,
                        ProGetConsultsForPatientRespTaggedConsultArraysInfo = mapper.MapEcToLob(state.ProEcResponse),
                        PatGetConsultsForPatientRespTaggedConsultArraysInfo = mapper.MapEcToLob(state.PatEcResponse),
                        ProUserDuz = state.ProUserDuz,
                        PatUserDuz = state.PatUserDuz,
                        EcProcessingMs = state.EcProcessingTimeMs
                    };
            }
        }
    }
}
